/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.structure2;

import java.util.Random;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.structure2.LOTRWorldGenStructureBase2;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class LOTRWorldGenCampBase
extends LOTRWorldGenStructureBase2 {
    protected Block tableBlock;
    protected Block brickBlock;
    protected int brickMeta;
    protected Block brickSlabBlock;
    protected int brickSlabMeta;
    protected Block fenceBlock;
    protected int fenceMeta;
    protected Block fenceGateBlock;
    protected Block farmBaseBlock;
    protected int farmBaseMeta;
    protected Block farmCropBlock;
    protected int farmCropMeta;
    protected boolean hasOrcTorches = false;
    protected boolean hasSkulls = false;

    public LOTRWorldGenCampBase(boolean flag) {
        super(flag);
    }

    @Override
    protected void setupRandomBlocks(Random random) {
        this.tableBlock = Blocks.field_150462_ai;
        this.brickBlock = Blocks.field_150347_e;
        this.brickMeta = 0;
        this.brickSlabBlock = Blocks.field_150333_U;
        this.brickSlabMeta = 3;
        this.fenceBlock = Blocks.field_150422_aJ;
        this.fenceMeta = 0;
        this.fenceGateBlock = Blocks.field_150396_be;
        this.farmBaseBlock = Blocks.field_150458_ak;
        this.farmBaseMeta = 7;
        this.farmCropBlock = Blocks.field_150464_aj;
        this.farmCropMeta = 7;
    }

    protected abstract LOTRWorldGenStructureBase2 createTent(boolean var1, Random var2);

    protected abstract LOTREntityNPC getCampCaptain(World var1, Random var2);

    protected void placeNPCRespawner(World world, Random random, int i, int j, int k) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean generateWithSetRotation(World world, Random random, int i, int j, int k, int rotation) {
        int k1;
        int i14;
        int tentZ;
        int l;
        int j1;
        if (this.restrictions) {
            if (!LOTRWorldGenStructureBase2.isSurfaceStatic(world, i, j - 1, k)) {
                return false;
            }
            if (world.func_147439_a(i, j, k).func_149688_o().func_76224_d()) {
                return false;
            }
        }
        this.setOriginAndRotation(world, i, j, k, rotation, 0);
        this.setupRandomBlocks(random);
        int groundRange = 12;
        for (int i12 = -groundRange; i12 <= groundRange; ++i12) {
            for (int k12 = -groundRange; k12 <= groundRange; ++k12) {
                int j12;
                int k2;
                int i2 = Math.abs(i12);
                if (i2 * i2 + (k2 = Math.abs(k12)) * k2 >= groundRange * groundRange || this.getBlock(world, i12, (j12 = this.getTopBlock(world, i12, k12)) - 1, k12) != Blocks.field_150349_c || random.nextInt(5) == 0) continue;
                this.setBlockAndMetadata(world, i12, j12 - 1, k12, Blocks.field_150346_d, 1);
            }
        }
        int highestHeight = 0;
        for (int i13 = -1; i13 <= 1; ++i13) {
            for (int k13 = -1; k13 <= 1; ++k13) {
                j1 = this.getTopBlock(world, i13, k13);
                if (j1 <= highestHeight) continue;
                highestHeight = j1;
            }
        }
        this.originY = this.getY(highestHeight);
        this.generateCentrepiece(world, random, 0, 0, 0);
        LOTREntityNPC captain = this.getCampCaptain(world, random);
        if (captain != null) {
            captain.spawnRidingHorse = false;
            this.spawnNPCAndSetHome(captain, world, 0, 1, 0, 24);
        }
        for (l = 0; l < 4; ++l) {
            int tentX = MathHelper.func_76136_a((Random)random, (int)-3, (int)3);
            tentZ = MathHelper.func_76136_a((Random)random, (int)6, (int)12);
            i14 = 0;
            k1 = 0;
            int rot = l;
            if (rot == 0) {
                i14 = tentX;
                k1 = tentZ;
            } else if (rot == 1) {
                i14 = tentZ;
                k1 = -tentX;
            } else if (rot == 2) {
                i14 = -tentX;
                k1 = -tentZ;
            } else if (rot == 3) {
                i14 = -tentZ;
                k1 = tentX;
            }
            int j13 = this.getTopBlock(world, i14, k1);
            this.generateSubstructure(this.createTent(this.notifyChanges, random), world, random, i14, j13, k1, rot);
        }
        if (this.hasOrcTorches) {
            int[] tentX = new int[]{-2, 2};
            tentZ = tentX.length;
            for (k1 = 0; k1 < tentZ; ++k1) {
                int i141 = tentX[k1];
                for (int k14 : new int[]{-2, 2}) {
                    int j14 = this.getTopBlock(world, i141, k14);
                    this.placeOrcTorch(world, i141, j14, k14);
                }
            }
        }
        if (this.generateFarm()) {
            int[] farmCoords = null;
            int farmRange = 12;
            int minFarmRange = 5;
            block7: for (int l2 = 0; l2 < 32; ++l2) {
                int k15;
                int i15 = MathHelper.func_76136_a((Random)random, (int)(-farmRange), (int)farmRange);
                int dSq = i15 * i15 + (k15 = MathHelper.func_76136_a((Random)random, (int)(-farmRange), (int)farmRange)) * k15;
                if (dSq <= minFarmRange * minFarmRange) continue;
                for (int i2 = i15 - 2; i2 <= i15 + 2; ++i2) {
                    for (int k2 = k15 - 2; k2 <= k15 + 2; ++k2) {
                        int j2 = this.getTopBlock(world, i2, k2) - 1;
                        if (!this.isSurface(world, i2, j2, k2) || !this.isAir(world, i2, j2 + 1, k2) && !this.isReplaceable(world, i2, j2 + 1, k2)) continue block7;
                    }
                }
                farmCoords = new int[]{i15, k15};
                break;
            }
            if (farmCoords != null) {
                void k2;
                int i2;
                i14 = farmCoords[0];
                void k16 = farmCoords[1];
                int highestFarmHeight = this.getTopBlock(world, i14, (int)k16);
                for (i2 = i14 - 2; i2 <= i14 + 2; ++i2) {
                    for (k2 = k16 - 2; k2 <= k16 + 2; ++k2) {
                        int j2 = this.getTopBlock(world, i2, (int)k2);
                        if (j2 <= highestFarmHeight) continue;
                        highestFarmHeight = j2;
                    }
                }
                for (i2 = i14 - 2; i2 <= i14 + 2; ++i2) {
                    for (k2 = k16 - 2; k2 <= k16 + 2; ++k2) {
                        int j2 = highestFarmHeight - 2;
                        while (!this.isOpaque(world, i2, j2, (int)k2) && this.getY(j2) >= 0) {
                            this.setBiomeFiller(world, i2, j2, (int)k2);
                            this.setGrassToDirt(world, i2, j2 - 1, (int)k2);
                            --j2;
                        }
                        if (Math.abs(i2 - i14) == 2 || Math.abs((int)(k2 - k16)) == 2) {
                            this.setBlockAndMetadata(world, i2, highestFarmHeight, (int)k2, this.fenceBlock, this.fenceMeta);
                            this.setBiomeTop(world, i2, highestFarmHeight - 1, (int)k2);
                            this.setGrassToDirt(world, i2, highestFarmHeight - 2, (int)k2);
                            continue;
                        }
                        if (i2 == i14 && k2 == k16) {
                            this.setBlockAndMetadata(world, i2, highestFarmHeight - 1, (int)k2, Blocks.field_150355_j, 0);
                            continue;
                        }
                        this.setBlockAndMetadata(world, i2, highestFarmHeight, (int)k2, this.farmCropBlock, this.farmCropMeta);
                        this.setBlockAndMetadata(world, i2, highestFarmHeight - 1, (int)k2, this.farmBaseBlock, this.farmBaseMeta);
                        this.setGrassToDirt(world, i2, highestFarmHeight - 2, (int)k2);
                    }
                }
                int gate = random.nextInt(4);
                if (gate == 0) {
                    this.setBlockAndMetadata(world, i14, highestFarmHeight, (int)(k16 + 2), this.fenceGateBlock, 0);
                } else if (gate == 1) {
                    this.setBlockAndMetadata(world, i14 - 2, highestFarmHeight, (int)k16, this.fenceGateBlock, 1);
                } else if (gate == 2) {
                    this.setBlockAndMetadata(world, i14, highestFarmHeight, (int)(k16 - 2), this.fenceGateBlock, 2);
                } else if (gate == 3) {
                    this.setBlockAndMetadata(world, i14 + 2, highestFarmHeight, (int)k16, this.fenceGateBlock, 3);
                }
                int scarecrowX = i14 + (random.nextBoolean() ? -2 : 2);
                void scarecrowZ = k16 + (random.nextBoolean() ? -2 : 2);
                this.setBlockAndMetadata(world, scarecrowX, highestFarmHeight + 1, (int)scarecrowZ, this.fenceBlock, this.fenceMeta);
                if (this.hasOrcTorches) {
                    this.setBlockAndMetadata(world, scarecrowX, highestFarmHeight + 2, (int)scarecrowZ, Blocks.field_150325_L, 12);
                    this.placeSkull(world, random, scarecrowX, highestFarmHeight + 3, (int)scarecrowZ);
                } else {
                    this.setBlockAndMetadata(world, scarecrowX, highestFarmHeight + 2, (int)scarecrowZ, Blocks.field_150407_cf, 0);
                    this.setBlockAndMetadata(world, scarecrowX, highestFarmHeight + 3, (int)scarecrowZ, Blocks.field_150423_aK, random.nextInt(4));
                }
            }
        }
        if (this.hasSkulls) {
            int i16;
            for (l = 0; l < 6; ++l) {
                int range = 8;
                i16 = MathHelper.func_76136_a((Random)random, (int)(-range), (int)range);
                if (i16 * i16 + (k1 = MathHelper.func_76136_a((Random)random, (int)(-range), (int)range)) * k1 <= 20 || !this.isSurface(world, i16, (j1 = this.getTopBlock(world, i16, k1)) - 1, k1) || !this.isReplaceable(world, i16, j1, k1) || !this.isAir(world, i16, j1 + 1, k1)) continue;
                this.setBlockAndMetadata(world, i16, j1, k1, this.fenceBlock, this.fenceMeta);
                this.placeSkull(world, random, i16, j1 + 1, k1);
            }
            for (l = 0; l < 6; ++l) {
                int range = 12;
                i16 = MathHelper.func_76136_a((Random)random, (int)(-range), (int)range);
                if (i16 * i16 + (k1 = MathHelper.func_76136_a((Random)random, (int)(-range), (int)range)) * k1 <= 20 || !this.isSurface(world, i16, (j1 = this.getTopBlock(world, i16, k1)) - 1, k1) || !this.isReplaceable(world, i16, j1, k1) || !this.isAir(world, i16, j1 + 1, k1)) continue;
                this.placeSkull(world, random, i16, j1, k1);
            }
        }
        this.placeNPCRespawner(world, random, 0, 0, 0);
        return true;
    }

    protected boolean generateFarm() {
        return true;
    }

    protected void generateCentrepiece(World world, Random random, int i, int j, int k) {
        for (int i1 = i - 1; i1 <= i + 1; ++i1) {
            for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                int j1 = j - 1;
                while (!this.isOpaque(world, i1, j1, k1) && this.getY(j1) >= 0) {
                    this.setBlockAndMetadata(world, i1, j1, k1, this.brickBlock, this.brickMeta);
                    this.setGrassToDirt(world, i1, j1 - 1, k1);
                    --j1;
                }
                this.setBlockAndMetadata(world, i1, j, k1, this.brickSlabBlock, this.brickSlabMeta);
                this.setGrassToDirt(world, i1, j - 1, k1);
            }
        }
        this.setBlockAndMetadata(world, i, j, k, this.tableBlock, 0);
    }
}

